set sql_safe_updates=0;
UPDATE `dydt_data_line_item` SET `resultColumnsDef`='PresentCount' WHERE `dataSourceCode`='STUDENT_CD_ATTENDANCE_COUNT_BY_ADMISSIONID' and`whetherPrimaryDataSource`='1';

SET @dataproviderId2=(SELECT id FROM dydt_data_provider WHERE `providerName`='Student Admission Program Data Provider');
UPDATE `dydt_data_line_item` 
SET 
    `sqlSelectQueryDef` = 'SELECT  p.programCode AS program_code,p.programName AS program_name,p.programNameToBePrint AS program_print_name,
 pd.shortCode AS primary_dept_code,pd.deptName AS primary_dept_name,
 psd.shortCode AS secondary_dept_code,psd.deptName AS secondary_dept_name,
 b.batchName AS batch_name ,b.startDate AS batch_start_date ,b.tillDate AS batch_tilldate,
 ay.itemValue AS intake_year ,a.code AS admission_code ,a.studentId as student_id,
 pbpc.programPeriodName AS period_name ,pbpc.printName AS period_print_name ,prsn.photoUrl AS img_photo_url ,date_format(DATE(NOW()), "%d-%m-%Y") as today_date,
 u.code AS person_code ,prsn.firstName AS first_name ,prsn.middleName AS middle_name,prsn.lastName AS last_name ,CONCAT(UCASE(LEFT(gender, 1)),LCASE(SUBSTRING(gender, 2))) as student_gender,cc.itemValue AS cast_category ,date_format(DATE(prsn.birthDate),"%d-%m-%Y") AS birth_date,ntn.itemValue as nationality,rel.itemValue as religions,sec.sectionCode as section_code,date_format(a.admissionDate, "%d-%m-%Y") as admission_date,
 TRUNCATE(DATEDIFF(date_format(DATE(NOW()), "%Y-%m-%d"),prsn.birthDate) / 365.25,0) as student_age, (case when (prsn.bloodGroup = "O_PLUS") then "O+" when (prsn.bloodGroup = "O_MINUS") then "O-" when (prsn.bloodGroup = "A_PLUS") then "A+" when (prsn.bloodGroup = "A_MINUS") then "A-" when (prsn.bloodGroup = "B_PLUS") then "B+" when (prsn.bloodGroup = "B_MINUS") then "B-" when (prsn.bloodGroup = "AB_PLUS") then "AB+" when (prsn.bloodGroup = "AB_MINUS") then "AB-" else null end) as blood_group
 FROM program_batch_students pbs 
 LEFT JOIN admission a ON a.id = pbs.admissionId
 LEFT JOIN batches b   ON b.id = pbs.programBatchId
 LEFT JOIN programs p ON b.programId = p.id
 LEFT JOIN intake_year ay ON ay.id = b.intakeYearId
 LEFT JOIN department pd ON pd.id = p.programDepartmentId
 LEFT JOIN department psd ON psd.id = p.subDepartmentId
 LEFT JOIN prog_batch_period_config pbpc ON pbpc.programBatchId = b.id
 LEFT JOIN students st ON st.userId = a.studentId
 LEFT JOIN persons prsn ON prsn.id = st.personId
 LEFT JOIN users u ON u.id = st.userId
 LEFT JOIN caste_categories cc ON cc.id = prsn.castCategoryId
 LEFT JOIN nationalities ntn on ntn.id = prsn.nationalityId
 LEFT JOIN religions rel on rel.id = prsn.religionId
 LEFT JOIN sections sec on sec.id = pbs.sectionId',
    `resultColumnsDef` = 'program_code,program_name,program_print_name, primary_dept_code,cast_category,birth_date,primary_dept_name,secondary_dept_code,secondary_dept_name, batch_name, batch_start_date,batch_tilldate,intake_year,section_code,admission_code,student_id,last_name,first_name,middle_name,person_code,img_photo_url,period_name,period_print_name,nationality,religions,today_date,student_age,student_gender,blood_group,admission_date',
    `sqlWhereQueryDef` = 'WHERE a.id = PRM_ADMISSION_ID AND pbs.isCurrentPeriod = true AND pbs.isCurrentSection = true AND pbs.exitDate is null'
WHERE
    `dataSourceCode` = 'STUDENT_ADMISSION_PROGRAM_INFO' AND dataProviderId = @dataproviderId2;
set sql_safe_updates=1;

